import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class VisualFieldPixel extends DrawObject
{
	// DrawObject abilities:
	@Override
	public boolean IsVisualFieldPixel()
	{
		return true;
	}

	@Override
	public boolean CanBeDeletedByUser()
	{
		return true;
	};

	@Override
	public boolean CanBeExcitedByUser()
	{
		return true;
	};

	@Override
	public boolean CanBeMovedByUser()
	{
		return true;
	};

	@Override
	public boolean CanBeSelectedByUser()
	{
		return true;
	};
	// end of DrawObject abilities

	public VisualFieldPixel(Point Pos)
	{
		SetPosNoAlignOnGrid(Pos);
		SetSize(new Point(20, 20));
		InitializeExcitement(ExcitementVisualFieldPixelMilliseconds);
	};

	@Override
	public void Draw(Graphics g)
	{
		if (!(IsWithinWindowBounds(this, 0)))
			return;

		// background (overdraw grid)
		SetColor(g, Color.DARK_GRAY);
		FillRect(g, Pos.x, Pos.y, Size.x, Size.y);

		// pixel filling
		if (IsHighlighted || IsPartOfMultiSelection)
			SetColor(g, Color.GREEN);
		else
			SetColor(g, GetExcitementColor(Color.DARK_GRAY));

		if (IsHighlighted || IsPartOfMultiSelection || IsEnabled || IsThereNoteworthyExcitement())
			FillRect(g, Pos.x, Pos.y, Size.x - 0, Size.y - 0);
		else
			DrawRect(g, Pos.x, Pos.y, Size.x - 1, Size.y - 1);

		// frame around each pixel
		SetColor(g, Color.BLACK);
		DrawRect(g, Pos.x, Pos.y, Size.x, Size.y);
	}

	@Override
	public void MarkAsZombie()
	{
		ParentDrawObject.MarkAsZombie();
	}

	protected void MarkAsZombieForThis()
	{
		IsZombie = true;
	}

	@Override
	public void Move(Point MoveAmount)
	{
		SetPosNoAlignOnGrid(new Point(Pos.x + MoveAmount.x, Pos.y + MoveAmount.y));

		ParentDrawObject.Move(MoveAmount);
	}

	protected void MoveThis(Point MoveAmount)
	{
		Pos.x += MoveAmount.x;
		Pos.y += MoveAmount.y;
	}

	protected void SetHighlightedForThis(boolean IsHighlightedNew)
	{
		IsHighlighted = IsHighlightedNew;
	}

	@Override
	public void SetPartOfMultiSelection(boolean IsPartNew)
	{
		// if one pixel is selected, just select all (and vice versa), to avoid only single pixels are moved

		IsPartOfMultiSelection = IsPartNew;

		ParentDrawObject.SetPartOfMultiSelection(IsPartNew);
	}

	protected void SetPartOfMultiSelectionForThis(boolean IsPartNew)
	{
		IsPartOfMultiSelection = IsPartNew;
	}

	@Override
	public void SetPos(Point PosNew)
	{
		// NOTE: the VisualField consists of a grid of pixels.
		// No matter which pixel the user drags, the whole grid must
		// be moved. This is done by moving the parent VisualField,
		// which moves all its child objects (the pixels).
		// The same also applies to SetHighlighted(),
		// SetPartOfMultiSelection() etc. (this scheme is
		// applied also to other DrawObjects, like the Neuron).

		Point PosNewWithOffset = new Point(PosNew.x - (Pos.x - ParentDrawObject.Pos.x), PosNew.y - (Pos.y - ParentDrawObject.Pos.y));

		ParentDrawObject.SetPos(PosNewWithOffset);
	}

	public void Toggle()
	{
		IsEnabled = !IsEnabled;
	}
}
